//=============================================================================
// ExtraCritical.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 最大ダメージレコード機構
 * @target MZ
 * @author くろあめ
 * 
 * @help
 * 「単発の攻撃ダメージ」と「ターン中に与えた総攻撃ダメージ」を記録し
 * それまでの記録を上回った場合、指定した変数に格納して保存します。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 *
 * @param singleMaxDamegeRecord
 * @text 単発最大ダメージ記録領域
 * @desc 単発（攻撃一回）の最大ダメージレコードを格納する変数のIDです。
 * @type variable
 * @default 20
 *
 * @param turnMaxDamageRecord
 * @text ターン中最大ダメージ記録領域
 * @desc １ターン中の最大ダメージレコードを格納する変数のIDです。
 * @type variable
 * @default 21
 *
 */

(function() {

'use strict';
const script = document.currentScript;
const pluginParams = PluginManagerEx.createParameter(script);

const SINGLE_MAXDAM_VARIABLE_ID = Number(pluginParams.singleMaxDamegeRecord);
const TURN_MAXDAM_VARIABLE_ID = Number(pluginParams.turnMaxDamageRecord);

const _BattleManager_initMembers_damrecord = BattleManager.initMembers;
BattleManager.initMembers = function() {
    _BattleManager_initMembers_damrecord.apply(this, arguments);
    this._turnAllAddDamege = 0;
    //console.log("init");
};
/*
const _BattleManager_startTurn_damrecord = BattleManager.startTurn;
BattleManager.startTurn = function() {
    _BattleManager_startTurn_damrecord.apply(this, arguments);
    //this._turnAllAddDamege = 0;
    //console.log("turnStart");
};
*/
const _BattleManager_endTurn_damrecord = BattleManager.endTurn;
BattleManager.endTurn = function() {
    _BattleManager_endTurn_damrecord.apply(this, arguments);
    this.recodeTurnAllAddDamege();
    //console.log("turnEnd");
};

const _BattleManager_processVictory_damrecord = BattleManager.processVictory;
BattleManager.processVictory = function() {
    //console.log("Victory");
    this.recodeTurnAllAddDamege();
    _BattleManager_processVictory_damrecord.apply(this, arguments);
};

const _BattleManager_processDefeat_damrecord = BattleManager.processDefeat;
BattleManager.processDefeat = function() {
    //console.log("Defeat");
    this._turnAllAddDamege = 0;
    _BattleManager_processDefeat_damrecord.apply(this, arguments);
};

BattleManager.addTurnAllAddDamege= function(value) {
    this._turnAllAddDamege += value;
};

BattleManager.recodeTurnAllAddDamege= function() {
    if(this._turnAllAddDamege > $gameVariables.value(TURN_MAXDAM_VARIABLE_ID)){
        $gameVariables.setValue(TURN_MAXDAM_VARIABLE_ID, this._turnAllAddDamege);
    }
    this._turnAllAddDamege = 0;
};

const _Game_Action_executeHpDamage_damrecord = Game_Action.prototype.executeHpDamage;
Game_Action.prototype.executeHpDamage = function(target, value) {

    _Game_Action_executeHpDamage_damrecord.apply(this, arguments);    
    if(this.subject().isActor()){
        this.setSingleMaxDam(value);
        BattleManager.addTurnAllAddDamege(value);
    }
};

Game_Action.prototype.setSingleMaxDam = function(value) {
    if(value == null){
        return;
    }
    if(value > $gameVariables.value(SINGLE_MAXDAM_VARIABLE_ID)){
        $gameVariables.setValue(SINGLE_MAXDAM_VARIABLE_ID, value);
    }
    return;
};

})();